	function [L, C, W0, K, Rs, RL] = CH_II_LADDER(G, Z, R_ZEROS, P, Wc, Ws, Amax, Amin, Rs, RL, Ladder, Type)
	
	%	Computes the element values for a doubly resistively terminated Chebyshev II 
	%	LC ladder of type a and b. The element values in a 
	%	lowpass Chebyshev II LC ladder filter of type a are the same as in type c.  
	%
	%	Ladder = 1 for a T ladder and 0 for a  ladder
	%	Rs = source resistor and RL = load resistor
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	%
	% 	Author:			Lars Wanhammar, 2007-09-01
	% 	Modified by:	LW 2008-08-12, 2014-04-19
	%	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	% Normalize the frequency and impedance level for improved accuracy
	R_ZEROS = zeros(1, length(P))';	%	Reflection zeros, all at s = 0
	[ZinNum, ZinDen] = ZIN_LADDER(Z, R_ZEROS, P); %	Compute Zin
	% Normalized source and load resistor for Chebyshev II ladders
	Rs0 = Rs; RL0 = RL;
	Rs = 1;		RL = 1;
	Type = lower(Type);
	
	[L, C, W0, K, winv] = LP_LADDER(ZinNum, ZinDen, Rs, RL, G, Z, P, Wc, Ws, Amax, Amin, Type);
	
	% ======================================================
	% 	Polishing of the element values
	%	The remaining lines may be activated if needed, by seting
	%	Polish = 1 in line 35. The element values are sligtly more accurate.
	%
	%	This part is not activated since it is not needed in most cases.
	
	Polish = 0;
	if Polish == 1
		Norder = length(P);
		[G, Z, R_ZEROS, P] = CH_II_POLES_S(Wc, Ws, Amax, Amin, Norder);
		if abc == 'b'	% even
			[G, Z, R_ZEROS, P, Wsnew] = CH_II_B_POLES_S(G, Z, P, Wc, Ws, Amax, Amin);
		end
	
		omegaP = sin([0:0.005:1]*pi/2); 
		Attideal = PZ_2_ATT_S(G, Z, P, omegaP);	
		const = (RL+Rs)/RL;
		% 	The improvment in the element values is limited by the accuracy of the 
		%	attenuation in the passband. Note that different algorithms for computing 
		%	the poles and zeros yield SLIGHTLY different results.
		
		[L, C, W0, K] = POLISH_LC(Attideal, omegaP, Norder, winv, L, C, K, Rs, RL, const);
	end
	if Ladder == 0
		[L, C, Rs, RL, K] = T_LADDER_2_PI(L, C, Rs, RL, K);
	end

	L = Rs0*L;
	C = C/Rs0;
	RL = RL*Rs0;
	Rs = Rs0;	
	
	
